/*****************************************************************************
 * Project: SCT Application Example for LPC1549
 *
 * Implements a start stop event example for SCT0 
 *
 * For this application the following interface pins are used:
 * -------------------------------------------------------------------------
 * Signal    Port               Signal      
 * -------------------------------------------------------------------------
 * SCT0_OUT0   P0_6   pin 16      COUNTER_L_RUN
 * SCT0_OUT1   P0_7   pin 17      COUNTER_H_RUN
 * SCT0_OUT2   P0_8   pin 19      STATE_1
 * SCT0_OUT3   P0_0   pin 2       STATE_2
 * ------------------------------------------------------------------------*/
#include "start_stop.h"

int main (void) 
{
    LPC_SWM->PINASSIGN7 &= 0x080706FF;             // SCT0_OUT0 at P0_6, SCT0_OUT1 at P0_7, SCT0_OUT2 at P0_8
    LPC_SWM->PINENABLE1 &= ~(1 << 5);              // SCT0_OUT3 at P0_0

    LPC_SYSCON->SYSAHBCLKCTRL1 |= (1 << 2);        // enable the SCT0 clock
    START_STOP_init();                             // initialize the SCT
    LPC_SCT0->CTRL_U = (0  << 0)  |                // DOWN_L [0]     = L counting down
                       (0  << 1)  |                // STOP_L [1]     = L counter does run
                       (0  << 2)  |                // HALT_L [2]     = unhalt the L counter
                       (1  << 3)  |                // CLRT_L [3]     = clear L counter
                       (0  << 4)  |                // BIDIR_L[4]     = not bidirectional counting
                       (11 << 5)  |                // PRE_L  [12:5]  = L prescaler = 12
                       (0  << 16) |                // DOWN_H [16]    = H counting down
                       (1  << 17) |                // STOP_H [1]     = stop the H counter
                       (0  << 18) |                // HALT_H [2]     = unhalt the H counter
                       (1  << 19) |                // CLRT_H [3]     = clear H counter
                       (0  << 20) |                // BIDIR_H[4]     = not bidirectional counting
                       (11 << 21);                 // PRE_H  [28:21] = H prescaler = 12
    
    while (1) 
    {
    }
}


